#pragma once

#include "output/result.h"
#include "output/serializer.h"
#include "replication/replicator.h"

#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <library/cpp/http/io/stream.h>
#include <library/cpp/http/misc/httpcodes.h>

#include <functional>
#include <memory>

class THttpResponse;

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NUtils {
    class TFileLogger;
}

namespace NPassport::NKolmogor {
    class TAuth;
    class TMemStorage;

    class TKolmogor {
    public:
        TKolmogor();
        ~TKolmogor();

        void Init(const NJson::TConfig& cfg);
        void HandleRequest(NCommon::TRequest& req);
        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        TResult ProcessRequest(NCommon::TRequest& req, std::optional<ui32>& tvmid);
        static void CheckDuplicatedArgs(const NCommon::TRequest& req);

        TResult ProcessV1(const NCommon::TRequest& req, TStringBuf path, std::optional<ui32>& tvmid);
        TResult ProcessV1Impl(const NCommon::TRequest& req, TStringBuf path, std::optional<ui32> tvmid);
        TResult ProcessV2(const NCommon::TRequest& req, std::optional<ui32>& tvmid);
        TResult ProcessV2Impl(const NCommon::TRequest& req, std::optional<ui32> tvmid);

        TResult HandlePing(const NCommon::TRequest& req) const;
        NV2::TIncResult HandleV1Inc(const NCommon::TRequest& req);
        TResult HandleV1Get(const NCommon::TRequest& req) const;
        TResult HandleV1Erase(const NCommon::TRequest& req, std::optional<ui32> tvmid);

        NV2::TIncResult HandleV2Inc(const TString& body, std::optional<ui32> tvmid);
        NV2::TGetResult HandleV2Get(const TString& body, std::optional<ui32> tvmid) const;
        NV2::TEraseAllResult HandleV2EraseAll(const TString& body);

        static TResult MakeResult(const TString& str,
                                  HttpCodes code = HttpCodes::HTTP_OK);
        static TResult MakeResult(const TString& str,
                                  const TString& contType,
                                  HttpCodes code = HttpCodes::HTTP_OK);

        template <class T>
        TResult MakeResultV2(const T& result, HttpCodes code = HttpCodes::HTTP_OK) const;

        void CheckAuth(const NCommon::TRequest& req, std::optional<ui32> tvmid) const;
        template <class T>
        void CheckAuth(const T& req, std::optional<ui32> tvmid) const;
        void CheckRequiredAuth(const NCommon::TRequest& req, std::optional<ui32> tvmid) const;
        void GetSrcFromServiceTicket(const NCommon::TRequest& req, std::optional<ui32>& out) const;

        static TString SerializeRequest(const NCommon::TRequest& req);

        void LogAccess(const NCommon::TRequest& req,
                       TResult&& res,
                       std::optional<ui32> tvmid,
                       TDuration time) const;

        void InitLoggers(const NJson::TConfig& config, const TString& path);
        void InitAuth(const NJson::TConfig& config, const TString& path);
        void InitStorage(const NJson::TConfig& config, const TString& path);
        void InitReplicator(const NJson::TConfig& config, const TString& path);
        void InitSpaces(const NJson::TConfig& config, const TString& path);
        void InitMisc(const NJson::TConfig& config, const TString& path);

        // Read dump from disk
        void LoadOnStart();
        // Wait for all workers to end and then save dump to disk
        void SaveOnExit();

    private:
        std::unique_ptr<TAuth> Auth_;
        std::unique_ptr<TMemStorage> Storage_;
        std::shared_ptr<TReplicator> Replicator_;

        TString ForceDownFile_;

        std::unique_ptr<NUtils::TFileLogger> AccessLog_;
    };
}
