#pragma once

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <optional>

namespace NPassport::NKolmogor::NV2 {
    struct TGetResult {
        struct TKeyValue {
            TString Key;
            ui64 Value = 0;
            std::optional<ui64> Diff;

            bool operator==(const TKeyValue& o) const {
                return Key == o.Key && Value == o.Value && Diff == o.Diff;
            }
        };
        using TValues = TSmallVec<TKeyValue>;

        struct TSpace {
            TString Name;
            TValues Values;

            bool operator==(const TSpace& o) const {
                return Name == o.Name && Values == o.Values;
            }
        };

        using TSpaces = TStackVec<TSpace, 4>;

        TSpaces Data;

        bool operator==(const TGetResult& o) const {
            return Data == o.Data;
        }
    };
}
