#include "serializer.h"

#include "eraseall_result.h"
#include "get_result.h"

#include <passport/infra/libs/cpp/json/writer.h>

namespace NPassport::NKolmogor::NV2 {
    static const TString VALUE_ = "value";
    static const TString ERROR_ = "error";
    static const TString WAS_INCREMENTED = "was_incremented";

    TString TSerializer::Serialize(const TGetResult& result) {
        TString res;
        NJson::TWriter wr(res);
        NJson::TObject root(wr);

        for (const TGetResult::TSpace& space : result.Data) {
            NJson::TObject spaceNode(root, space.Name);

            for (const TGetResult::TKeyValue& kv : space.Values) {
                NJson::TObject keyNode(spaceNode, kv.Key);
                keyNode.Add(VALUE_, kv.Value);
                if (kv.Diff) {
                    keyNode.Add(WAS_INCREMENTED, *kv.Diff > 0);
                }
            }
        }

        return res;
    }

    TString TSerializer::Serialize(const TError& result) {
        TString res;
        NJson::TWriter wr(res);
        NJson::TObject root(wr);

        root.Add(ERROR_, result.Error);

        return res;
    }

    TString TSerializer::Serialize(const TEraseAllResult& result) {
        TString res;
        NJson::TWriter wr(res);
        NJson::TObject root(wr);

        NJson::TObject spaceNode(root, result.SpaceName);
        spaceNode.Add("keys", result.DeletedKeys);

        return res;
    }
}
