#include "acceptor.h"

#include "request/base_request.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/system/thread.h>

namespace NPassport::NKolmogor {
    TAcceptor::TAcceptor(grpc::CompletionQueue& cq, const TClientSet& clients, TTailSet& tails)
        : ClientCq_(cq)
        , Clients_(clients)
        , Tails_(tails)
        , Worker_([this] { Run(); })
    {
    }

    TAcceptor::~TAcceptor() {
        ClientCq_.Shutdown();
        Worker_.join();
        TLog::Debug() << "Pusher: exit all";
    }

    void TAcceptor::Run() {
        TThread::SetCurrentThreadName("kolmogor_accep");

        void* tag = nullptr;
        bool isOk = false;
        while (ClientCq_.Next(&tag, &isOk)) {
            try {
                std::unique_ptr<TBaseRequest> req(static_cast<TBaseRequest*>(tag));
                Y_ENSURE(req);

                req->ProcessResponse(isOk, Clients_, Tails_);
            } catch (const std::exception& e) {
                TLog::Error() << "Acceptor: exception: " << e.what();
            }
        }
    }
}
