#include "clientset.h"

#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NKolmogor {
    TClientSet::TClientSet(grpc::CompletionQueue& cq,
                           const TAuth& auth,
                           const TClientSettings& settings,
                           const TStrVec& uris)
        : ClientCq_(cq)
        , Auth_(auth)
        , ClientSettings_(settings)
    {
        Set(uris);
    }

    void TClientSet::AddUnistat(NUnistat::TBuilder& builder) {
        for (const TClientPtr& c : Set_) {
            c->AddUnistat(builder);
        }

        builder.Add(UnistatAllErrors_);
    }

    void TClientSet::Set(TStrVec uris) {
        std::sort(uris.begin(), uris.end());
        uris.erase(std::unique(uris.begin(), uris.end()), uris.end());

        for (const TString& uri : uris) {
            TLog::Info() << "Pusher: add dest: " << uri;
            auto c = std::make_shared<TClient>(uri, ClientCq_, Auth_, ClientSettings_, UnistatAllErrors_);
            c->SendPing();
            Set_.insert(std::move(c));
        }
    }

    void TClientSet::PingAll() const {
        for (const TClientPtr& c : Set_) {
            c->SendPing();
        }
    }

    void TClientSet::CleanAll() {
        for (const TClientPtr& c : Set_) {
            c->CleanDebt();
        }
    }

    TClientPtr TClientSet::Get(const TString& addr) const {
        auto itCl = Set_.find(addr);
        if (itCl == Set_.end()) {
            TLog::Warning() << "Acceptor: client not found: " << addr;
            return {};
        }

        return *itCl;
    }

    const TClientSet::TSet& TClientSet::GetAllClients() const {
        return Set_;
    }
}
