#pragma once

#include "client.h"

#include <passport/infra/daemons/kolmogor/src/common/type.h>

#include <contrib/libs/grpc/include/grpcpp/completion_queue.h>

#include <set>
#include <shared_mutex>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NKolmogor {
    class TClientSet {
    public:
        using TSet = std::set<TClientPtr>;

        TClientSet(grpc::CompletionQueue& cq,
                   const TAuth& auth,
                   const TClientSettings& settings,
                   const TStrVec& uris);

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        void Set(TStrVec uris);

    public:
        void PingAll() const;
        void CleanAll();

        TClientPtr Get(const TString& addr) const;

        const TSet& GetAllClients() const;

    private:
        grpc::CompletionQueue& ClientCq_;
        const TAuth& Auth_;
        const TClientSettings ClientSettings_;
        TSet Set_;

        NUnistat::TSignalDiff<> UnistatAllErrors_ = {"replication.total.errors"};
    };
}
