#pragma once

#include "clientset.h"

#include <passport/infra/daemons/kolmogor/src/common/type.h>
#include <passport/infra/daemons/kolmogor/src/proto/replication.v2.pb.h>

#include <util/datetime/base.h>

#include <map>

namespace NPassport::NKolmogor {
    class TAuth;
    class TEraser {
    public:
        TEraser(const TClientSet& clients, size_t retries, TDuration timeout);

        TString Erase(const TString& space,
                      const TString& keys,
                      TInstant instant,
                      time_t expirationTime) const;

    private:
        static TToErasePtr BuildRequest(const TString& space,
                                        TStringBuf keys,
                                        TInstant instant,
                                        time_t expirationTime);

    private:
        const TClientSet& Clients_;
        const size_t Retries_;
        const TDuration Timeout_;
    };

    class TEraseState {
    public:
        TEraseState(const TClientSet::TSet& clients, TToErasePtr data, size_t retries, TDuration timeout);

        TString Run(time_t expirationTime);

    private:
        struct TClientState {
            enum class EStatus {
                Sent,
                Ready,
            } Status = EStatus::Sent;

            TString LastError;
            ui32 Tries = 0;
        };

    private:
        void InitRequests(grpc::CompletionQueue& cq);
        bool ProcessResponses(grpc::CompletionQueue& cq);
        void AddDebt(grpc::CompletionQueue& cq, time_t expirationTime);

        TClientState& GetState(const TClient& c);

        TString BuildErrorText() const;

    private:
        std::map<TClientPtr, TClientState> Clients_;
        const TToErasePtr Data_;
        const TDuration Timeout_;
        size_t Retries_;
    };
}
