#pragma once

#include "clientset.h"

#include <passport/infra/daemons/kolmogor/src/common/type.h>
#include <passport/infra/daemons/kolmogor/src/storage/mem_storage.h>
#include <passport/infra/daemons/kolmogor/src/storage/slice.h>

#include <passport/infra/libs/cpp/logbroker/resource_dispatcher/resource_dispatcher.h>

#include <contrib/libs/grpc/include/grpcpp/completion_queue.h>

namespace NPassport::NKolmogor {
    class TAcceptor;
    class TAuth;
    class TDebtCleaner;
    class TEraser;
    class TServer;
    class TPinger;
    class TTailSet;

    // Facade
    struct TReplicatorSettings {
        ui16 Port = 0;
        ui32 Threads = 0;
        TDuration PingPeriod;
        TDuration Timeout;
        ui32 GroupCount = 0;
        TDuration DebtCleanPeriod;
        TStrVec Uris;
        ui32 EraseRetries = 0;
        TDuration EraseTimeout;
        int MaxMessageSize = 0;
        ui64 MaxDebtSize = 0;
    };

    class TReplicator {
    public:
        TReplicator(TMemStorage& storage, const TAuth& auth, const TReplicatorSettings& config);
        ~TReplicator();

        void AddUnistat(NUnistat::TBuilder& builder);

        void AddSpace(const TString& space, ui16 threadCount);

        void AddToTail(const TString& space, TStrVec&& keys, TInstant instant, time_t expire);
        TString SendErase(const TString& space, const TString& keys, TInstant instant, time_t expirationTime);

        void StartWork();
        void StopThreads();

    private:
        std::shared_ptr<NLb::TResourceDispatcher> DebtDispatcher_;

        grpc::CompletionQueue ClientCq_;

        TClientSet Clients_;
        std::unique_ptr<TTailSet> Tails_;
        std::unique_ptr<TEraser> Eraser_;

        std::unique_ptr<TServer> Server_;
        std::unique_ptr<TAcceptor> Acceptor_;

        // must be last members
        std::unique_ptr<TPinger> Pinger_;
        std::unique_ptr<TDebtCleaner> Cleaner_;
    };
}
