#pragma once

#include <passport/infra/daemons/kolmogor/src/proto/replication.v2.grpc.pb.h>

#include <contrib/libs/grpc/include/grpcpp/client_context.h>
#include <contrib/libs/grpc/include/grpcpp/completion_queue.h>
#include <contrib/libs/grpc/include/grpcpp/support/status.h>

#include <util/datetime/base.h>

namespace NPassport::NKolmogor {
    class TAuth;
    class TClient;
    class TClientSet;
    class TTailSet;

    class TBaseRequest {
    public:
        static const TString X_YA_SERVICE_TICKET; // https://st.yandex-team.ru/DTCC-695

        using TStub = kolmogor::replication::v2::Repl::Stub;

        enum EFinishStatus {
            Ok,
            Error,
        };

        TBaseRequest(TClient& client, grpc::CompletionQueue& cq);
        virtual ~TBaseRequest() = default;

        TClient& GetClient() {
            return Client_;
        }

        virtual void Send(TStub& stub, const TAuth& auth, TDuration timeout) = 0;

        virtual void ProcessResponse(bool isOk,
                                     const TClientSet& clients,
                                     TTailSet& tails) = 0;

        virtual ui64 GetRequestSize() = 0;

    protected:
        virtual TStringBuf LogName() const = 0;

        void SetTimeout(TDuration timeout);
        void SetAuth(const TAuth& auth);
        bool CheckStatus(bool isOk, TString* err = nullptr);

    protected:
        grpc::Status Status_;
        grpc::ClientContext Ctx_;

        TClient& Client_;
        grpc::CompletionQueue& Cq_;
    };

    using TBaseRequestPtr = std::unique_ptr<TBaseRequest>;
}
