#include "erase_request.h"

#include <passport/infra/daemons/kolmogor/src/replication/tailset.h>

namespace NPassport::NKolmogor {
    TString TEraseRequest::GetErrorForSyncRequest(bool isOk) {
        if (isOk && Status_.error_code() == grpc::StatusCode::NOT_FOUND) {
            return {};
        }

        TString err;
        CheckStatus(isOk, &err);

        return err;
    }

    void TEraseRequest::Cancel() {
        Ctx_.TryCancel();
    }

    void TEraseRequest::Send(TBaseRequest::TStub& stub, const TAuth& auth, TDuration timeout) {
        SetTimeout(timeout);
        SetAuth(auth);

        auto rpc = stub.AsyncErase(&Ctx_, *Request_, &Cq_);
        rpc->Finish(&Response_, &Status_, this);
    }

    void TEraseRequest::ProcessResponse(bool isOk, const TClientSet&, TTailSet& tails) {
        if (isOk && Status_.error_code() == grpc::StatusCode::NOT_FOUND) {
            tails.DeleteClient(Request_->Getgen().Getspace(), Client_);
            return;
        }

        if (CheckStatus(isOk)) {
            return;
        }

        const time_t expireTime = Request_->gen().GetexpireTime();
        Client_.AddDebt(Clone(), expireTime);
    }

    TStringBuf TEraseRequest::LogName() const {
        return "Erase";
    }

    TBaseRequestPtr TEraseRequest::Clone() const {
        return std::make_unique<TEraseRequest>(Client_, Cq_, Request_);
    }

    ui64 TEraseRequest::GetRequestSize() {
        return Request_->ByteSizeLong();
    }

}
