#pragma once

#include "base_request.h"

namespace NPassport::NKolmogor {
    using TToErasePtr = std::shared_ptr<kolmogor::replication::v2::ToErase>;

    class TEraseRequest: public TBaseRequest {
    public:
        TEraseRequest(TClient& client, grpc::CompletionQueue& cq, TToErasePtr toErase)
            : TBaseRequest(client, cq)
            , Request_(std::move(toErase))
        {
        }

        TString GetErrorForSyncRequest(bool isOk);
        void Cancel();

        void Send(TStub& stub, const TAuth& auth, TDuration timeout) override;

        void ProcessResponse(bool isOk,
                             const TClientSet& clients,
                             TTailSet& tails) override;

        TStringBuf LogName() const override;

        ui64 GetRequestSize() override;

    private:
        TBaseRequestPtr Clone() const;

    private:
        TToErasePtr Request_;
        kolmogor::replication::v2::DummyResponse Response_;
    };
}
