#include "ping_request.h"

#include <passport/infra/daemons/kolmogor/src/replication/clientset.h>
#include <passport/infra/daemons/kolmogor/src/replication/tailset.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NKolmogor {
    void TPingRequest::Send(TBaseRequest::TStub& stub, const TAuth&, TDuration timeout) {
        SetTimeout(timeout);

        kolmogor::replication::v2::Hello hello;

        auto rpc = stub.AsyncPing(&Ctx_, hello, &Cq_);
        rpc->Finish(&Pong_, &Status_, this);
    }

    void TPingRequest::ProcessResponse(bool isOk, const TClientSet& clients, TTailSet& tails) {
        if (!CheckStatus(isOk)) {
            return;
        }

        auto clientPtr = clients.Get(Client_.Uri());
        for (const TString& space : Pong_.Getspaces()) {
            tails.AddClient(space, clientPtr);
        }
    }

    ui64 TPingRequest::GetRequestSize() {
        return 0;
    }

    TStringBuf TPingRequest::LogName() const {
        return "Ping";
    }
}
