#pragma once

#include "base_request.h"

namespace NPassport::NKolmogor {
    class TPingRequest: public TBaseRequest {
    public:
        TPingRequest(TClient& client, grpc::CompletionQueue& cq)
            : TBaseRequest(client, cq)
        {
        }

        void Send(TStub& stub, const TAuth& auth, TDuration timeout) override;

        void ProcessResponse(bool isOk,
                             const TClientSet& clients,
                             TTailSet& tails) override;
        TStringBuf LogName() const override;

        ui64 GetRequestSize() override;

    private:
        kolmogor::replication::v2::Pong Pong_;
    };
}
