#include "push_request.h"

#include <passport/infra/daemons/kolmogor/src/replication/tailset.h>

namespace NPassport::NKolmogor {
    void TPushRequest::Send(TBaseRequest::TStub& stub, const TAuth& auth, TDuration timeout) {
        SetTimeout(timeout);
        SetAuth(auth);

        auto rpc = stub.AsyncPush(&Ctx_, *Request_, &Cq_);
        rpc->Finish(&Response_, &Status_, this);
    }

    void TPushRequest::ProcessResponse(bool isOk, const TClientSet&, TTailSet& tails) {
        if (isOk && Status_.error_code() == grpc::StatusCode::NOT_FOUND) {
            tails.DeleteClient(Request_->Getgen().Getspace(), Client_);
            return;
        }

        if (CheckStatus(isOk)) {
            return;
        }

        const time_t expireTime = Request_->gen().GetexpireTime();
        Client_.AddDebt(Clone(), expireTime);
    }

    ui64 TPushRequest::GetRequestSize() {
        return Request_->ByteSizeLong();
    }

    TStringBuf TPushRequest::LogName() const {
        return "Push";
    }

    TBaseRequestPtr TPushRequest::Clone() const {
        return std::make_unique<TPushRequest>(Client_, Cq_, Request_);
    }
}
