#pragma once

#include "base_request.h"

namespace NPassport::NKolmogor {
    using TTailPtr = std::shared_ptr<kolmogor::replication::v2::Tail>;

    class TPushRequest: public TBaseRequest {
    public:
        TPushRequest(TClient& client, grpc::CompletionQueue& cq, TTailPtr tail)
            : TBaseRequest(client, cq)
            , Request_(std::move(tail))
        {
        }

        void Send(TStub& stub, const TAuth& auth, TDuration timeout) override;

        void ProcessResponse(bool isOk,
                             const TClientSet& clients,
                             TTailSet& tails) override;
        TStringBuf LogName() const override;

        ui64 GetRequestSize() override;

    private:
        TBaseRequestPtr Clone() const;

    private:
        TTailPtr Request_;
        kolmogor::replication::v2::DummyResponse Response_;
    };
}
