#include "base_response.h"

#include <passport/infra/daemons/kolmogor/src/replication/request/base_request.h>

#include <passport/infra/daemons/kolmogor/src/common/auth.h>
#include <passport/infra/daemons/kolmogor/src/storage/mem_storage.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NKolmogor {
    TBaseResponse::TBaseResponse(kolmogor::replication::v2::Repl::AsyncService& service,
                                 grpc::ServerCompletionQueue& cq)
        : Service_(service)
        , Cq_(cq)
    {
    }

    bool TBaseResponse::Run(TResponserUnistat& unistat) {
        switch (State_) {
            case EStateMachine::Process:
                CreateNext();
                try {
                    Proceed(unistat);
                } catch (const std::exception& e) {
                    TLog::Warning() << "Server: got exception in proceed: " << e.what();
                }
                State_ = EStateMachine::Finish;
                return true;
            case EStateMachine::Finish:
                return false;
        }
    }

    grpc::Status TBaseResponse::CheckAuth(const TAuth& auth, const grpc::ServerContext& context) {
        auto it = context.client_metadata().find(TBaseRequest::X_YA_SERVICE_TICKET);
        if (it == context.client_metadata().end()) {
            return grpc::Status(grpc::StatusCode::UNAUTHENTICATED,
                                "Missing key 'x-ya-service-ticket' in metadata");
        }

        try {
            auth.CheckServiceTicketForReplication(
                TStringBuf(it->second.data(), it->second.size()));
        } catch (const std::exception& e) {
            TLog::Warning() << "Failed to check service ticket for replication: " << e.what();
            return grpc::Status(grpc::StatusCode::PERMISSION_DENIED,
                                "Bad service ticket in 'x-ya-service-ticket'",
                                e.what());
        }

        return grpc::Status::OK;
    }

    grpc::Status TBaseResponse::CheckSpace(TMemStorage& storage, const TString& space) {
        if (!storage.HasSpace(space)) {
            TLog::Warning() << "Replication: push: No such space: " << space;
            return grpc::Status(grpc::StatusCode::NOT_FOUND,
                                "No such space",
                                space);
        }

        return grpc::Status::OK;
    }
}
