#pragma once

#include <passport/infra/daemons/kolmogor/src/proto/replication.v2.grpc.pb.h>

#include <contrib/libs/grpc/include/grpcpp/completion_queue.h>
#include <contrib/libs/grpc/include/grpcpp/server_context.h>

namespace NPassport::NKolmogor {
    class TAuth;
    class TMemStorage;
    struct TResponserUnistat;

    class TBaseResponse {
    public:
        TBaseResponse(kolmogor::replication::v2::Repl::AsyncService& service,
                      grpc::ServerCompletionQueue& cq);
        virtual ~TBaseResponse() = default;

        bool Run(TResponserUnistat& unistat);

    protected:
        virtual void Proceed(TResponserUnistat& unistat) = 0;
        virtual void CreateNext() = 0;

        static grpc::Status CheckAuth(const TAuth& auth, const grpc::ServerContext& context);
        static grpc::Status CheckSpace(TMemStorage& storage, const TString& space);

    protected:
        kolmogor::replication::v2::Repl::AsyncService& Service_;
        grpc::ServerCompletionQueue& Cq_;

        grpc::ServerContext Ctx_;

    private:
        enum class EStateMachine {
            Process,
            Finish,
        };
        EStateMachine State_ = EStateMachine::Process;
    };
}
