#include "erase_response.h"

#include <passport/infra/daemons/kolmogor/src/replication/server.h>

#include <passport/infra/daemons/kolmogor/src/storage/mem_storage.h>

namespace NPassport::NKolmogor {
    TEraseResponse::TEraseResponse(kolmogor::replication::v2::Repl::AsyncService& service,
                                   grpc::ServerCompletionQueue& cq,
                                   TMemStorage& storage,
                                   const TAuth& auth)
        : TBaseResponse(service, cq)
        , Responder_(&Ctx_)
        , Storage_(storage)
        , Auth_(auth)
    {
        Service_.RequestErase(&Ctx_, &Request_, &Responder_, &Cq_, &Cq_, this);
    }

    void TEraseResponse::CreateNext(kolmogor::replication::v2::Repl::AsyncService& service,
                                    grpc::ServerCompletionQueue& cq,
                                    TMemStorage& storage,
                                    const TAuth& auth) {
        new TEraseResponse(service, cq, storage, auth);
    }

    void TEraseResponse::CreateNext() {
        CreateNext(Service_, Cq_, Storage_, Auth_);
    }

    void TEraseResponse::Proceed(TResponserUnistat& unistat) {
        ++unistat.Total;
        ++unistat.EraseRequests;

        grpc::Status status = CheckAuth(Auth_, Ctx_);
        if (!status.ok()) {
            Responder_.FinishWithError(status, this);
            return;
        }

        const TString& space = Request_.gen().Getspace();
        status = CheckSpace(Storage_, space);
        if (!status.ok()) {
            Responder_.FinishWithError(status, this);
            return;
        }

        TStrVec vec;
        vec.reserve(Request_.data().key_size());
        for (const TString& s : Request_.data().key()) {
            vec.push_back(s);
        }

        Storage_.Erase(space, vec, TInstant::FromValue(Request_.data().instant()));

        unistat.EraseKeys += vec.size();

        auto it = unistat.PerSpace.find(space);
        Y_VERIFY(it != unistat.PerSpace.end());
        TResponserUnistat::TPerSpace& perSpace = *it->second;

        ++perSpace.EraseRequests;
        perSpace.EraseKeys += vec.size();

        Responder_.Finish(Response_, grpc::Status::OK, this);
    }
}
