#include "ping_response.h"

#include <passport/infra/daemons/kolmogor/src/replication/server.h>

namespace NPassport::NKolmogor {
    TPingResponse::TPingResponse(kolmogor::replication::v2::Repl::AsyncService& service,
                                 grpc::ServerCompletionQueue& cq,
                                 const std::vector<TString>& spaces)
        : TBaseResponse(service, cq)
        , Responder_(&Ctx_)
        , Spaces_(spaces)
    {
        Service_.RequestPing(&Ctx_, &Request_, &Responder_, &Cq_, &Cq_, this);
    }

    void TPingResponse::CreateNext(kolmogor::replication::v2::Repl::AsyncService& service,
                                   grpc::ServerCompletionQueue& cq,
                                   const std::vector<TString>& spaces) {
        new TPingResponse(service, cq, spaces);
    }

    void TPingResponse::CreateNext() {
        CreateNext(Service_, Cq_, Spaces_);
    }

    void TPingResponse::Proceed(TResponserUnistat& unistat) {
        ++unistat.Total;
        ++unistat.Hello;

        for (const TString& space : Spaces_) {
            Response_.add_spaces(space);
        }

        Responder_.Finish(Response_, grpc::Status::OK, this);
    }
}
