#pragma once

#include "base_response.h"

namespace NPassport::NKolmogor {
    class TPingResponse: public TBaseResponse {
    public:
        TPingResponse(kolmogor::replication::v2::Repl::AsyncService& service,
                      grpc::ServerCompletionQueue& cq,
                      const std::vector<TString>& spaces);

        static void CreateNext(kolmogor::replication::v2::Repl::AsyncService& service,
                               grpc::ServerCompletionQueue& cq,
                               const std::vector<TString>& spaces);
        void CreateNext() override;

        void Proceed(TResponserUnistat& unistat) override;

    private:
        kolmogor::replication::v2::Hello Request_;
        kolmogor::replication::v2::Pong Response_;

        grpc::ServerAsyncResponseWriter<kolmogor::replication::v2::Pong> Responder_;

        const std::vector<TString>& Spaces_;
    };
}
