#include "push_response.h"

#include <passport/infra/daemons/kolmogor/src/replication/server.h>

#include <passport/infra/daemons/kolmogor/src/storage/mem_storage.h>

namespace NPassport::NKolmogor {
    TPushResponse::TPushResponse(kolmogor::replication::v2::Repl::AsyncService& service,
                                 grpc::ServerCompletionQueue& cq,
                                 TMemStorage& storage,
                                 const TAuth& auth)
        : TBaseResponse(service, cq)
        , Responder_(&Ctx_)
        , Storage_(storage)
        , Auth_(auth)
    {
        Service_.RequestPush(&Ctx_, &Request_, &Responder_, &Cq_, &Cq_, this);
    }

    void TPushResponse::CreateNext(kolmogor::replication::v2::Repl::AsyncService& service,
                                   grpc::ServerCompletionQueue& cq,
                                   TMemStorage& storage,
                                   const TAuth& auth) {
        new TPushResponse(service, cq, storage, auth);
    }

    void TPushResponse::CreateNext() {
        CreateNext(Service_, Cq_, Storage_, Auth_);
    }

    void TPushResponse::Proceed(TResponserUnistat& unistat) {
        ++unistat.Total;
        ++unistat.IncRequests;

        grpc::Status status = CheckAuth(Auth_, Ctx_);
        if (!status.ok()) {
            Responder_.FinishWithError(status, this);
            return;
        }

        const TString& space = Request_.gen().Getspace();
        status = CheckSpace(Storage_, space);
        if (!status.ok()) {
            Responder_.FinishWithError(status, this);
            return;
        }

        if (Request_.data().empty()) {
            Responder_.Finish(Response_, grpc::Status::OK, this);
            return;
        }

        TStrVec vec;
        vec.reserve(Request_.data(0).key_size());

        for (const kolmogor::replication::v2::Data& data : Request_.data()) {
            vec.clear();
            for (const TString& k : data.key()) {
                vec.push_back(k);
            }

            Storage_.Inc(space, vec, TInstant::FromValue(data.instant()));
            unistat.IncKeys += data.key_size();

            auto it = unistat.PerSpace.find(space);
            Y_VERIFY(it != unistat.PerSpace.end());
            TResponserUnistat::TPerSpace& perSpace = *it->second;

            ++perSpace.IncRequests;
            perSpace.IncKeys += data.key_size();
        }

        Responder_.Finish(Response_, grpc::Status::OK, this);
    }
}
