#pragma once

#include <passport/infra/daemons/kolmogor/src/proto/replication.v2.grpc.pb.h>

#include <passport/infra/libs/cpp/unistat/diff.h>

#include <contrib/libs/grpc/include/grpcpp/server.h>

#include <util/thread/pool.h>

#include <condition_variable>
#include <mutex>
#include <thread>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NKolmogor {
    class TAuth;
    class TMemStorage;

    struct TResponserUnistat {
        void AddSpace(const TString& space);

        struct TPerSpace {
            TPerSpace(const TString& space);

            NUnistat::TSignalDiff<> IncRequests;
            NUnistat::TSignalDiff<> IncKeys;
            NUnistat::TSignalDiff<> EraseRequests;
            NUnistat::TSignalDiff<> EraseKeys;
        };

        std::unordered_map<TString, std::unique_ptr<TPerSpace>> PerSpace;

        NUnistat::TSignalDiff<> IncRequests = {"replication.total.inc.requests"};
        NUnistat::TSignalDiff<> IncKeys = {"replication.total.inc.keys"};
        NUnistat::TSignalDiff<> EraseRequests = {"replication.total.erase.requests"};
        NUnistat::TSignalDiff<> EraseKeys = {"replication.total.erase.keys"};

        NUnistat::TSignalDiff<> Hello = {"replication.hello"};
        NUnistat::TSignalDiff<> Total = {"replication.total"};
    };

    struct TServerSettings {
        ui16 Port = 0;
        size_t Threads = 0;
        int MaxMessageSize = 0;
    };

    class TServer {
    public:
        TServer(TMemStorage& storage, const TAuth& auth, const TServerSettings& settings);
        ~TServer();

        void AddSpace(const TString& space);

        void StartWork();
        void BeginStoping();

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        struct TThreadItem {
            std::thread T;
            std::unique_ptr<grpc::ServerCompletionQueue> Cq;
        };

    private:
        std::unique_ptr<kolmogor::replication::v2::Repl::AsyncService> Service_;
        std::unique_ptr<grpc::Server> Server_;
        const TServerSettings Settings_;

        TMemStorage& Storage_;
        const TAuth& Auth_;
        std::vector<TString> Spaces_;

        TResponserUnistat Unistat_;

        std::vector<TThreadItem> Pool_;
    };
}
