#pragma once

#include "client.h"

#include <passport/infra/daemons/kolmogor/src/common/type.h>
#include <passport/infra/daemons/kolmogor/src/proto/replication.v2.pb.h>
#include <passport/infra/daemons/kolmogor/src/storage/counter/counter_params.h>

#include <passport/infra/libs/cpp/unistat/absolute.h>
#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <util/generic/string.h>
#include <util/thread/lfqueue.h>

#include <memory>
#include <set>
#include <shared_mutex>
#include <vector>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NKolmogor {
    class TAuth;
    class TTail {
    public:
        TTail(const TString& space, ui16 groupCount, ui16 threadCount);
        ~TTail();

        TTail(const TTail&) = delete;
        TTail& operator=(const TTail&) = delete;
        TTail(TTail&&) = delete;
        TTail& operator=(TTail&&) = delete;

        void AddUnistat(NUnistat::TBuilder& builder);

        void AddData(TStrVec&& keys, TInstant instant, time_t expire);

        void AddClient(TClientPtr c);
        void DeleteClient(const TString& uri);

        const TString Space;

    private:
        struct TNode {
            TStrVec Keys;
            TInstant Instant;
            time_t Expire = 0L;
        };

        void Worker();
        std::pair<kolmogor::replication::v2::Tail, time_t> MakeCurrentPart();
        bool PushPart();

        static void AddDataToProto(kolmogor::replication::v2::Tail& req, const TNode& data);

        TLockFreeQueue<TNode> Queue_;
        std::set<TClientPtr> Clients_;

        std::shared_timed_mutex MutexClients_;

        ui16 GroupCount_;
        NUnistat::TSignalAbsolute<> UnistatSize_;

        // must be last member
        std::vector<std::unique_ptr<NUtils::TRegularTask>> Workers_;
    };
}
