#include "tailset.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NKolmogor {
    TTailSet::TTailSet(ui16 groupCount)
        : GroupCount_(groupCount)
    {
    }

    void TTailSet::AddUnistat(NUnistat::TBuilder& builder) {
        for (const auto& [space, tail] : Tails_) {
            tail->AddUnistat(builder);
        }
    }

    void TTailSet::AddData(const TString& space,
                           TStrVec&& keys,
                           TInstant instant,
                           time_t expire) {
        auto it = Tails_.find(space);
        if (it == Tails_.end()) {
            TLog::Debug() << "TailSet: failed to add data for space: " << space;
            return;
        }

        it->second->AddData(std::move(keys), instant, expire);
    }

    void TTailSet::AddSpace(const TString& space, ui16 threadCount) {
        Tails_.emplace(space, std::make_unique<TTail>(space, GroupCount_, threadCount));
    }

    void TTailSet::AddClient(const TString& space, TClientPtr client) {
        auto it = Tails_.find(space);
        if (it != Tails_.end()) {
            it->second->AddClient(client);
        }
    }

    void TTailSet::DeleteClient(const TString& space, const TClient& client) {
        auto it = Tails_.find(space);
        if (it == Tails_.end()) {
            return;
        }

        it->second->DeleteClient(client.Uri());
        TLog::Debug() << "Drop space " << space << " for client " << client.Uri();
    }
}
