#pragma once

#include "tail.h"

#include <passport/infra/daemons/kolmogor/src/storage/mem_storage.h>

#include <shared_mutex>
#include <unordered_map>

namespace NPassport::NKolmogor {
    class TAuth;
    class TTailSet {
    public:
        TTailSet(ui16 groupCount);

        void AddUnistat(NUnistat::TBuilder& builder);

        void AddData(const TString& space, TStrVec&& keys, TInstant instant, time_t expire);

        void AddSpace(const TString& space, ui16 threadCount);

        void AddClient(const TString& space, TClientPtr client);
        void DeleteClient(const TString& space, const TClient& client);

    private:
        using TTailPtr = std::unique_ptr<TTail>;

        ui16 GroupCount_;
        std::unordered_map<TString, TTailPtr> Tails_;
    };
}
