#include "counter_params.h"

#include <ctime>

namespace NPassport::NKolmogor {
    TCounterParams::TCounterParams(ui32 counterTtl, ui32 counterCount)
        : CounterCount(counterCount)
        , CounterTtl(counterTtl)
        , ActualDuration(counterTtl / counterCount)
    {
    }

    TKolmoPeriod TCounterParams::CurrentPeriod() const {
        return FromInstant(TInstant::Now());
    }

    TKolmoPeriod TCounterParams::FromInstant(TInstant time) const {
        return {ui32(time.Seconds() / ActualDuration)};
    }

    TInstant TCounterParams::ToInstantBegining(TKolmoPeriod time) const {
        return TInstant::Seconds(time.Val * ActualDuration);
    }

    time_t TCounterParams::ExpireTime(TInstant instant) const {
        const ui64 sec = instant.Seconds();
        return sec + CounterTtl - (sec % ActualDuration);
    }

    bool TCounterParams::IsExpired(TKolmoPeriod period, TKolmoPeriod cur) const {
        return period.Val < cur.Val - CounterCount + 1;
    }

    bool TCounterParams::operator==(const TCounterParams& r) const {
        return CounterCount == r.CounterCount && CounterTtl == r.CounterTtl;
    }

    bool TCounterParams::operator!=(const TCounterParams& r) const {
        return !(*this == r);
    }
}
