#pragma once

#include "type.h"

namespace NPassport::NKolmogor {
    class TCounterParams {
    public:
        TCounterParams() = default;
        TCounterParams(ui32 counterTtl, ui32 counterCount);

        TKolmoPeriod CurrentPeriod() const;
        TKolmoPeriod FromInstant(TInstant time) const;
        TInstant ToInstantBegining(TKolmoPeriod time) const;
        time_t ExpireTime(TInstant instant) const;
        bool IsExpired(TKolmoPeriod period, TKolmoPeriod cur) const;

        bool operator==(const TCounterParams& r) const;
        bool operator!=(const TCounterParams& r) const;

        const ui32 CounterCount = 0;
        const ui32 CounterTtl = 0;
        const ui32 ActualDuration = 0;
    };
}
