#pragma once

#include "counter_params.h"

#include <passport/infra/daemons/kolmogor/src/proto/persistency.pb.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NKolmogor {
    class TSplitedCounter: TMoveOnly {
    public:
        TSplitedCounter(const TCounterParams& params);

        static TSplitedCounter FromProto(const TCounterParams& params,
                                         const kolmogor_persistency::Slice::Pair::SplitedCounter& key);
        void ToProto(kolmogor_persistency::Slice::Pair::SplitedCounter& out) const;

        ui64 Get(const TKolmoPeriod cur) const;
        void Inc(TInstant instant, const TKolmoPeriod cur, ui32 value = 1);
        void Erase(TInstant instant);

        bool NeedClean(const TKolmoPeriod cur) const;

        TString ToDebugString() const;

        struct TPiece {
            TKolmoPeriod PeriodNo;
            ui32 Counter = 1;
        };

    private:
        void CleanExpired(const TKolmoPeriod cur);

        bool IsValid(TKolmoPeriod period, const TKolmoPeriod cur) const;

        const TCounterParams Params_;
        TKolmoPeriod ErasedUpToPeriod_;
        TInstant ErasedUpToInstant_;
        std::vector<TPiece> Data_;
    };
}
