#pragma once

#include <util/datetime/base.h>
#include <util/system/types.h>

#include <time.h>

namespace NPassport::NKolmogor {
    template <int T>
    struct TCustomInt {
        ui32 Val = 0;
    };

    template <int T>
    inline bool operator==(const TCustomInt<T>& l, const TCustomInt<T>& r) {
        return l.Val == r.Val;
    }
    template <int T>
    inline bool operator!=(const TCustomInt<T>& l, const TCustomInt<T>& r) {
        return l.Val != r.Val;
    }
    template <int T>
    inline bool operator<(const TCustomInt<T>& l, const TCustomInt<T>& r) {
        return l.Val < r.Val;
    }
    template <int T>
    inline bool operator<=(const TCustomInt<T>& l, const TCustomInt<T>& r) {
        return l.Val <= r.Val;
    }
    template <int T>
    inline bool operator>(const TCustomInt<T>& l, const TCustomInt<T>& r) {
        return l.Val > r.Val;
    }
    template <int T>
    inline bool operator>=(const TCustomInt<T>& l, const TCustomInt<T>& r) {
        return l.Val >= r.Val;
    }

    namespace NPrivate {
        enum class EInt {
            Period,
        };
    }
    using TKolmoPeriod = TCustomInt<(int)NPrivate::EInt::Period>;
}
