#pragma once

#include "space.h"

#include <passport/infra/daemons/kolmogor/src/common/type.h>
#include <passport/infra/daemons/kolmogor/src/input/eraseall_request.h>
#include <passport/infra/daemons/kolmogor/src/input/get_request.h>
#include <passport/infra/daemons/kolmogor/src/input/inc_request.h>
#include <passport/infra/daemons/kolmogor/src/output/eraseall_result.h>
#include <passport/infra/daemons/kolmogor/src/output/get_result.h>
#include <passport/infra/daemons/kolmogor/src/output/inc_result.h>

#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <library/cpp/charset/ci_string.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <set>
#include <shared_mutex>
#include <unordered_map>
#include <vector>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NKolmogor {
    class TReplicator;

    class TCleaner: public NUtils::TRegularTask {
    public:
        using NUtils::TRegularTask::TRegularTask;

        TDuration GetTimeToSleep() const override {
            TDuration period = Period_.load(std::memory_order_relaxed);

            TInstant now = TInstant::Now();
            TDuration diff = TDuration::MicroSeconds(now.MicroSeconds() % period.MicroSeconds());

            return period - diff;
        }
    };

    struct TMemStorageSettings {
        TString DataDirectory;
        TDuration MinCleanPeriod = TDuration::Seconds(3600);
        size_t CleanCount = 128;
        ui32 ThreadsForDump = 0;
    };

    class TMemStorage {
    public:
        TMemStorage();
        TMemStorage(const TMemStorageSettings& settings);
        ~TMemStorage();

        void AddSpace(const TSpaceSettings& conf);

        NV2::TIncResult IncFromHttp(NV2::TIncRequest&& req);                   // for http service
        void Inc(const TString& space, const TStrVec& keys, TInstant instant); // for replicator
        NV2::TGetResult Get(const NV2::TGetRequest& req, TSpace::EAPI apiVer) const;
        TString Erase(const TString& space, const TString& rawKeys);             // for http service
        void Erase(const TString& space, const TStrVec& keys, TInstant instant); // for replicator
        NV2::TEraseAllResult EraseAll(const NV2::TEraseAllRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);

        bool HasSpace(const TString& space) const;

        void SetReplicator(std::weak_ptr<TReplicator> replicator);
        void SendReplication(const TString& space,
                             TStrVec&& keys,
                             TInstant instant,
                             time_t expire);
        TString SendReplicationErase(const TString& space,
                                     const TString& keys,
                                     TInstant instant,
                                     time_t expirationTime);

        void StartCleaning();

        void StopThreads();

        void LoadOnStart();
        void SaveOnExit();

    private:
        void Cleaner();

        void EnsurePath();

        std::unordered_map<TString, std::unique_ptr<TSpace>> Stor_;
        TSpaceUnistat Unistat_;

        const TMemStorageSettings Settings_;

        std::weak_ptr<TReplicator> Replicator_;

        // must be last member
        std::unique_ptr<NUtils::TRegularTask> Cleaner_;
    };
}
