#pragma once
#include <passport/infra/daemons/kolmogor/src/storage/counter/counter_params.h>
#include <passport/infra/daemons/kolmogor/src/storage/counter/splited_counter.h>

#include <passport/infra/daemons/kolmogor/src/common/type.h>
#include <passport/infra/daemons/kolmogor/src/output/get_result.h>
#include <passport/infra/daemons/kolmogor/src/output/inc_result.h>

#include <passport/infra/libs/cpp/unistat/absolute.h>

#include <library/cpp/charset/ci_string.h>
#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <memory>
#include <shared_mutex>
#include <unordered_map>

class TThreadPool;

namespace NPassport::NKolmogor {
    class TSpaceSizeStats {
    public:
        TSpaceSizeStats(const TString& id, std::optional<size_t> memoryLimit = {});

        bool TryAdd(size_t size);
        void Erase(size_t size);

        const NUnistat::TSignalAbsolute<>& Keys() const {
            return Keys_;
        }

        const NUnistat::TSignalAbsolute<>& Memory() const {
            return Memory_;
        }

        const NUnistat::TSignalDiff<>& Limited() const {
            return Keys_;
        }

    private:
        NUnistat::TSignalAbsolute<> Keys_;
        NUnistat::TSignalAbsolute<> Memory_;
        NUnistat::TSignalDiff<> Limited_;
        std::optional<size_t> MemoryLimit_;
    };
    using TSpaceSizeStatsPtr = std::shared_ptr<TSpaceSizeStats>;

    class TSlice {
    public:
        TSlice(size_t reserve,
               const TCounterParams& params,
               size_t cleanCount,
               size_t eraseCount,
               TSpaceSizeStatsPtr stats);

        TSlice(const TSlice&) = delete;
        TSlice& operator=(const TSlice&) = delete;
        TSlice(TSlice&&) = default;

        bool Inc(const TStrVec& keys, const TIdxVec& idxs, TInstant instant, const TKolmoPeriod cur);
        bool IncAndGet(const TIdxVec& idxs,
                       const TInstant instant,
                       const TKolmoPeriod cur,
                       NV2::TIncResult::TValues& out);

        void Get(const TIdxVec& idxs, const TKolmoPeriod cur, NV2::TGetResult::TValues& out) const;

        bool Erase(const TStrVec& keys, const TIdxVec& idxs, const TInstant instant);

        struct TCleanInfo {
            bool IsDirty = false;
            size_t LastIdx = 0UL;
            size_t Deleted = 0UL;
            TDuration Duration;
        };
        TCleanInfo Clean(TKolmoPeriod cur, size_t idx);
        TCleanInfo EraseAll(TInstant instant, size_t idx);

        void Load(TThreadPool& queue, const TString& fileInputName);
        void Save(TThreadPool& queue, const TString& fileOutputName) const;

    private:
        TSplitedCounter* FindOrInsertNode(const TString& key);

    private:
        std::unique_ptr<std::shared_timed_mutex> Mutex_;
        std::unordered_map<TString, TSplitedCounter, THash<TString>> Data_;

        const TCounterParams Params_;

        const size_t MemoryPerKey_;
        const size_t CleanCount_;
        const size_t EraseCount_ = 512;
        TSpaceSizeStatsPtr Stats_;
    };
}
