LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    passport/infra/daemons/kolmogor/src/proto
    passport/infra/daemons/kolmogor/src/storage/counter

    passport/infra/libs/cpp/json
    passport/infra/libs/cpp/juggler
    passport/infra/libs/cpp/logbroker/resource_dispatcher
    passport/infra/libs/cpp/request
    passport/infra/libs/cpp/tvm/common
    passport/infra/libs/cpp/tvm/logger
    passport/infra/libs/cpp/unistat
    passport/infra/libs/cpp/utils

    library/cpp/config
    library/cpp/containers/stack_vector
    library/cpp/http/server
    library/cpp/json
    library/cpp/tvmauth/client
)

SRCS(
    common/auth.cpp
    common/utils.cpp
    input/get_request.cpp
    input/inc_request.cpp
    input/eraseall_request.cpp
    kolmogor.cpp
    output/serializer.cpp
    replication/acceptor.cpp
    replication/client.cpp
    replication/clientset.cpp
    replication/debt_cleaner.cpp
    replication/eraser.cpp
    replication/pinger.cpp
    replication/replicator.cpp
    replication/request/base_request.cpp
    replication/request/erase_request.cpp
    replication/request/ping_request.cpp
    replication/request/push_request.cpp
    replication/response/base_response.cpp
    replication/response/erase_response.cpp
    replication/response/ping_response.cpp
    replication/response/push_response.cpp
    replication/server.cpp
    replication/tail.cpp
    replication/tailset.cpp
    storage/mem_storage.cpp
    storage/slice.cpp
    storage/space.cpp
)

END()
