#include <passport/infra/daemons/kolmogor/src/storage/counter/counter_params.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NKolmogor;

Y_UNIT_TEST_SUITE(CounterParamsCtor) {
    Y_UNIT_TEST(CounterParamsCtor) {
        TCounterParams params(1000, 100);

        UNIT_ASSERT_EQUAL(10, params.ActualDuration);
        UNIT_ASSERT_EQUAL(100, params.CounterCount);
    }

    Y_UNIT_TEST(CounterParamsIsExpired) {
        TCounterParams params(1000, 100);

        UNIT_ASSERT(!params.IsExpired({10000}, {10000}));
        UNIT_ASSERT(!params.IsExpired({10000}, {10020}));
        UNIT_ASSERT(!params.IsExpired({10000}, {10090}));
        UNIT_ASSERT(params.IsExpired({10000}, {10100}));
        UNIT_ASSERT(params.IsExpired({10000}, {99999}));

        UNIT_ASSERT(!params.IsExpired({10000}, {100}));
        UNIT_ASSERT(!params.IsExpired({10000}, {110}));
    }
}
