#include <passport/infra/daemons/kolmogor/src/input/inc_request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NKolmogor::NV2;

Y_UNIT_TEST_SUITE(InputIncRequestTest) {
    Y_UNIT_TEST(parse) {
        UNIT_ASSERT_VALUES_EQUAL(
            TIncParser::Parse(
                R"({
                     "test_space": [
                         {
                             "keys": ["zxc", "zxc"]
                         },
                         {
                             "keys": ["asd", "zxc"]
                         }
                     ],
                     "test_space_2": [{
                         "keys": ["qwe2"]
                     }]
                 })"),
            TIncRequest({
                .Req = {
                    TIncRequest::TSpace{
                        .Name = "test_space",
                        .Keysets = {
                            {.Keys = {"zxc", "zxc"}},
                            {.Keys = {"asd", "zxc"}},
                        },
                        .KeysCount = 4,
                    },
                    TIncRequest::TSpace{
                        .Name = "test_space_2",
                        .Keysets = {{.Keys = {"qwe2"}}},
                        .KeysCount = 1,
                    },
                },
            }));

        UNIT_ASSERT_VALUES_EQUAL(
            TIncParser::Parse(
                R"({
                     "test_space": [
                         {
                             "keys": ["zxc", "zxc"]
                         },
                         {
                             "keys": ["asd", "qwe"],
                             "inc_if_less_than": 17
                         }
                     ],
                     "test_space_2": [{
                         "keys": ["qwe2"]
                     }]
                 })"),
            TIncRequest({
                .Req = {
                    TIncRequest::TSpace{
                        .Name = "test_space",
                        .Keysets = {
                            {.Keys = {"zxc", "zxc"}},
                            {.Keys = {"asd", "qwe"}, .IncIfLessThan = 17},
                        },
                        .KeysCount = 4,
                    },
                    TIncRequest::TSpace{
                        .Name = "test_space_2",
                        .Keysets = {{.Keys = {"qwe2"}}},
                        .KeysCount = 1,
                    },
                },
            }));
    }
}

template <>
void Out<TIncRequest>(IOutputStream& o, const TIncRequest& value) {
    for (const TIncRequest::TSpace& s : value.Req) {
        o << s << Endl;
    }
}

template <>
void Out<TIncRequest::TSpace>(IOutputStream& o, const TIncRequest::TSpace& value) {
    o << value.Name << " (" << value.KeysCount << "): ";
    for (const TIncRequest::TKeySet& k : value.Keysets) {
        o << k << "|";
    }
}

template <>
void Out<TIncRequest::TKeySet>(IOutputStream& o, const TIncRequest::TKeySet& value) {
    for (const TString& k : value.Keys) {
        o << k << ",";
    }
    o << "inc_if_less_than:";
    if (value.IncIfLessThan) {
        o << *value.IncIfLessThan;
    } else {
        o << "<NULL>";
    }
}
