#include <passport/infra/daemons/kolmogor/src/input/inc_request.h>
#include <passport/infra/daemons/kolmogor/src/storage/space.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NKolmogor;

Y_UNIT_TEST_SUITE(SpaceTest) {
    NV2::TIncResult::TValues Sort(NV2::TIncResult::TValues&& v) {
        std::sort(v.begin(), v.end(), [](const auto& l, const auto& r) {
            return l.Key < r.Key;
        });
        return v;
    }

    Y_UNIT_TEST(incAndGet) {
        TSpaceSettings cfg{
            .Name = "test_sp",
            .SliceCount = 128,
            .Reserve = 5000,
            .CounterTtl = 3600,
            .CounterCount = 12,
            .Persistency = false,
        };

        TSpace s(cfg, "./", 1000);
        NV2::TIncRequest::TSpace keys;

        keys.Keysets = {{.Keys = {"zxc", "zxc", "asd", "zxc"}}};
        UNIT_ASSERT_VALUES_EQUAL(Sort(s.IncAndGet(keys, TInstant::Now())),
                                 NV2::TIncResult::TValues({
                                     NV2::TIncResult::TKeyValue{.Key = "asd", .Value = 1},
                                     NV2::TIncResult::TKeyValue{.Key = "zxc", .Value = 3},
                                 }));

        keys.Keysets = {{.Keys = {"qwe", "asd", "zxc", "asd", "zxc"}}};
        UNIT_ASSERT_VALUES_EQUAL(Sort(s.IncAndGet(keys, TInstant::Now())),
                                 NV2::TIncResult::TValues({
                                     NV2::TIncResult::TKeyValue{.Key = "asd", .Value = 3},
                                     NV2::TIncResult::TKeyValue{.Key = "qwe", .Value = 1},
                                     NV2::TIncResult::TKeyValue{.Key = "zxc", .Value = 5},
                                 }));
    }
}
