#include <passport/infra/daemons/kolmogor/src/storage/counter/splited_counter.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NKolmogor;

Y_UNIT_TEST_SUITE(SplitedCounterTest) {
    Y_UNIT_TEST(SplitedCounterNeedClean) {
        int count = 100;
        TCounterParams params(1000, count);
        TSplitedCounter c(params);

        TKolmoPeriod now = {1130};

        UNIT_ASSERT(c.NeedClean({100}));

        c.Erase(params.ToInstantBegining({now.Val - 9}));
        UNIT_ASSERT(!c.NeedClean({150}));
        UNIT_ASSERT(!c.NeedClean(now));
        UNIT_ASSERT(!c.NeedClean({now.Val + 1}));
        UNIT_ASSERT(!c.NeedClean({now.Val + 15}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 10}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 9}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 1}));
        UNIT_ASSERT(c.NeedClean({now.Val + count}));
        UNIT_ASSERT(c.NeedClean({now.Val + count + 12}));
        UNIT_ASSERT(c.NeedClean({1000000000}));

        c.Inc(params.ToInstantBegining({now.Val - 7}), now);

        UNIT_ASSERT(!c.NeedClean({150}));
        UNIT_ASSERT(!c.NeedClean(now));
        UNIT_ASSERT(!c.NeedClean({now.Val + 1}));
        UNIT_ASSERT(!c.NeedClean({now.Val + 15}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 10}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 8}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 7}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 1}));
        UNIT_ASSERT(c.NeedClean({now.Val + count}));
        UNIT_ASSERT(c.NeedClean({now.Val + count + 12}));
        UNIT_ASSERT(c.NeedClean({1000000000}));

        c.Erase(params.ToInstantBegining({now.Val - 5}));
        UNIT_ASSERT(!c.NeedClean({150}));
        UNIT_ASSERT(!c.NeedClean(now));
        UNIT_ASSERT(!c.NeedClean({now.Val + 1}));
        UNIT_ASSERT(!c.NeedClean({now.Val + 15}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 10}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 6}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 5}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 1}));
        UNIT_ASSERT(c.NeedClean({now.Val + count}));
        UNIT_ASSERT(c.NeedClean({now.Val + count + 12}));
        UNIT_ASSERT(c.NeedClean({1000000000}));

        c.Erase(params.ToInstantBegining({now.Val - 9}));
        UNIT_ASSERT(!c.NeedClean({150}));
        UNIT_ASSERT(!c.NeedClean(now));
        UNIT_ASSERT(!c.NeedClean({now.Val + 1}));
        UNIT_ASSERT(!c.NeedClean({now.Val + 15}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 10}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 6}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 5}));
        UNIT_ASSERT(c.NeedClean({now.Val + count - 1}));
        UNIT_ASSERT(c.NeedClean({now.Val + count}));
        UNIT_ASSERT(c.NeedClean({now.Val + count + 12}));
        UNIT_ASSERT(c.NeedClean({1000000000}));

        c.Inc(params.ToInstantBegining(now), {now});

        UNIT_ASSERT(!c.NeedClean({150}));
        UNIT_ASSERT(!c.NeedClean(now));
        UNIT_ASSERT(!c.NeedClean({now.Val + 1}));
        UNIT_ASSERT(!c.NeedClean({now.Val + 15}));
        UNIT_ASSERT(!c.NeedClean({now.Val + count - 1}));
        UNIT_ASSERT(c.NeedClean({now.Val + count}));
        UNIT_ASSERT(c.NeedClean({now.Val + count + 12}));
        UNIT_ASSERT(c.NeedClean({1000000000}));
    }

    Y_UNIT_TEST(SplitedCounterGet) {
        int count = 100;
        TCounterParams params(1000, count);
        TSplitedCounter c(params);

        TKolmoPeriod now = {1130};

        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Inc(params.ToInstantBegining(now), now);
        UNIT_ASSERT_VALUES_EQUAL("1130:1;", c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Inc(params.ToInstantBegining(now), now);
        UNIT_ASSERT_VALUES_EQUAL("1130:2;", c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Inc(params.ToInstantBegining({now.Val - 1}), now);
        c.Inc(params.ToInstantBegining({now.Val - 1}), now);
        c.Inc(params.ToInstantBegining({now.Val - 1}), now);
        UNIT_ASSERT_VALUES_EQUAL("1129:3;1130:2;", c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Inc(params.ToInstantBegining({now.Val - 7}), now);
        c.Inc(params.ToInstantBegining({now.Val - 7}), now);
        UNIT_ASSERT_VALUES_EQUAL("1123:2;1129:3;1130:2;", c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(7, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Erase(params.ToInstantBegining({now.Val - 3}));
        UNIT_ASSERT_VALUES_EQUAL("1123:2;1129:3;1130:2;", c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(5, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Erase(params.ToInstantBegining({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL("1123:2;1129:0;1130:2;", c.ToDebugString());
        c.Inc(params.ToInstantBegining({now.Val - 7}), now);
        c.Inc(params.ToInstantBegining({now.Val - 7}), now);
        UNIT_ASSERT_VALUES_EQUAL("1123:2;1129:0;1130:2;", c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL_C(2, c.Get({100}), c.ToDebugString());
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(2, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Erase(params.ToInstantBegining(now));
        c.Inc(params.ToInstantBegining(now), now);
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));

        c.Inc(params.ToInstantBegining(now) + TDuration::Seconds(1), now);
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({100}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 8}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 7}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 2}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val - 1}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get(now));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 8}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 7}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 2}));
        UNIT_ASSERT_VALUES_EQUAL(1, c.Get({now.Val + count - 1}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({now.Val + count}));
        UNIT_ASSERT_VALUES_EQUAL(0, c.Get({1000000000}));
    }

    Y_UNIT_TEST(magicBug) {
        TCounterParams params(3600, 12);

        TSplitedCounter s(params);
        TInstant now = TInstant::Now();
        TKolmoPeriod cur = params.FromInstant(now);

        auto check = [&](std::vector<ui64> expected) {
            UNIT_ASSERT_VALUES_EQUAL(expected.size(), 13);
            std::vector<ui64> actual;
            for (ui32 idx = 0; idx < expected.size(); ++idx) {
                actual.push_back(s.Get({cur.Val + idx}));
            }
            UNIT_ASSERT_VALUES_EQUAL_C(expected, actual, s.ToDebugString());
        };

        s.Inc(now, cur);
        check({1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0});

        s.Inc(now - TDuration::Seconds(1500), cur);
        check({2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 0});

        s.Inc(now - TDuration::Seconds(1200), cur);
        check({3, 3, 3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 0});

        s.Inc(now - TDuration::Seconds(300), cur);
        check({4, 4, 4, 4, 4, 4, 4, 3, 2, 2, 2, 1, 0});

        s.Inc(now - TDuration::Seconds(1500), cur);
        check({5, 5, 5, 5, 5, 5, 5, 3, 2, 2, 2, 1, 0});

        s.Inc(now - TDuration::Seconds(600), cur);
        check({6, 6, 6, 6, 6, 6, 6, 4, 3, 3, 2, 1, 0});
    }
}
