import sys


SETTINGS = {
    "development": {
        "CYPRESS_DIR": "//home/passport-rt/development/lbcbck/",
        "TABLE_TTL": 3,
        "LOGBROKER_CLIENT_ID": "blackbox/lbcbck_dev",
        "LOGBROKER_TOPIC__BLACKBOX_LOG": "blackbox/blackbox-log",
        "LOGBROKER_TOPIC__OAUTH_LOG": "oauth/oauth-log",
        "MAX_UNCOMMITTED_SIZE": 80 * 1024 * 1024,
    },
    "testing": {
        "CYPRESS_DIR": "//home/passport-rt/testing/lbcbck/",
        "TABLE_TTL": 3,
        "LOGBROKER_CLIENT_ID": "blackbox/lbcbck_test",
        "LOGBROKER_TOPIC__BLACKBOX_LOG": "blackbox/blackbox-log-testing",
        "LOGBROKER_TOPIC__OAUTH_LOG": "oauth/oauth-log-testing",
        "MAX_UNCOMMITTED_SIZE": 80 * 1024 * 1024,
    },
    "production": {
        "CYPRESS_DIR": "//home/passport-rt/production/lbcbck/",
        "TABLE_TTL": 190,
        "LOGBROKER_CLIENT_ID": "blackbox/lbcbck",
        "LOGBROKER_TOPIC__BLACKBOX_LOG": "blackbox/blackbox-log",
        "LOGBROKER_TOPIC__OAUTH_LOG": "oauth/oauth-log",
        "MAX_UNCOMMITTED_SIZE": 400 * 1024 * 1024,
    },
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('{{%s}}' % key, str(value))

    if '{{' in template or '}}' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
