#pragma once

#include "lb_parser.h"

#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/logbroker/pusher/base_pusher.h>
#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/yt/batch.h>
#include <passport/infra/libs/cpp/yt/yt_client.h>

#include <util/thread/lfqueue.h>

#include <memory>
#include <vector>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLbcbck {
    using TLbReaderPool = NLb::TReaderPool<TLbParser::TResult>;
    using TLbReaderPoolPtr = NLb::TReaderPoolPtr<TLbParser::TResult>;

    class TDataPusher: public NLb::NPusher::TBasePusher<TDataPusher, TLbParser::TResult> {
        using TBase = NLb::NPusher::TBasePusher<TDataPusher, TLbParser::TResult>;

    public:
        TDataPusher(TLbReaderPoolPtr readerPool);
        ~TDataPusher();

        void AddUnistat(NUnistat::TBuilder& builder) const;

    public:
        struct TUnistat {
            NUnistat::TSignalDiff<> Requests = {"yt.requests"};
            NUnistat::TSignalDiff<> WrittenBytes = {"yt.written_bytes"};
            std::shared_ptr<NUnistat::TTimeStat> TimeStats;
        } Unistat;
    };

    struct TSettings {
        NYt::TYtClientFactoryPtr Yt;
        NLb::NPusher::TBaseWorkerSettings Base;
        NYt::TBatchSettings BatchSettings;
    };

    class TDataPushWorker: public NLb::NPusher::TBaseWorker<TDataPusher> {
        using TBase = NLb::NPusher::TBaseWorker<TDataPusher>;

    public:
        TDataPushWorker(TSettings settings, size_t idx, TDataPusher& parent);

        bool Proc(TLbReaderPool::TParsedData& data);

    private:
        const NYt::TBatchSettings BatchSettings_;
        NYt::TYtClient Client_;
    };

    using TDataPusherPtr = std::unique_ptr<TDataPusher>;
}
