#pragma once

#include "yt_query.h"

#include <passport/infra/libs/cpp/logbroker/processing/base_parser.h>
#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/yt/periodic_table.h>
#include <passport/infra/libs/cpp/yt/query.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <array>
#include <memory>

namespace NPassport::NLbcbck {
    struct TLbParserSettings {
        size_t LimitPerPair = 0;
    };

    class TLbParser: public NLb::TBaseParser {
    public:
        class TRowCtx {
        public:
            enum class EKey {
                Format,
                Action,
                Status,
                UserIp,
                Unixtime,
                Host,
                DefUid,
                Uids,
                Uid,
                UserPort,
                ClientId,

                Count
            };

            TRowCtx(TStringBuf buf);
            TStringBuf Get(EKey key) const;

        private:
            std::array<TStringBuf, (int)EKey::Count> Values_;
        };

        using TResult = NYt::TWriteQueries<NYt::TDailyTable>;

    public:
        TLbParser();
        TResult Parse(const NLb::TDataSet<>& data);

        size_t GetRowsOut() const {
            return TotalRowsOut_;
        }

    protected:
        bool ParseRow(TStringBuf line) override;
        void Reserve(size_t size) override;
        void LogBadLine(TStringBuf line) override;

        static TRowsConverter& GetConverter(TResult& result,
                                            const TWritableRow& row,
                                            size_t reserve);
        static std::optional<TWritableRow> TryParse(TStringBuf line);

        static TWritableRow ParseAsSescheck(const TRowCtx& ctx);
        static std::optional<TWritableRow> ParseAsOauthcheck(const TRowCtx& ctx);

    protected:
        TResult Result_;
        std::unordered_set<TWritableRow> UniqueRows_;

    private:
        size_t Reserve_ = 0;
        size_t TotalRowsOut_ = 0;
    };
}
