#pragma once

#include "data_pusher.h"
#include "yt_schema.h"

#include <passport/infra/libs/cpp/logbroker/processing/reader_pool.h>
#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/yt/table_creator.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <memory>
#include <vector>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NYt {
    class TYtClientFactory;
}

namespace NPassport::NLbcbck {
    class TLbcbck {
    public:
        TLbcbck();
        ~TLbcbck();

        void Init(const NXml::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);

        void RotateLogs();

    private:
        void InitTvmtool(const NXml::TConfig& config, const TString& path);
        void InitLogbroker(const NXml::TConfig& config, const TString& path);
        NYt::TBatchSettings InitYt(const NXml::TConfig& config, const TString& path);
        void InitProcessor(const NXml::TConfig& config,
                           const TString& path,
                           const NYt::TBatchSettings& settings);

        void Start();
        void Stop();

    private:
        NYt::TYtClientFactoryPtr YtFactory_; // must be destroyed after stopping operation with YT
        NYt::TTableCreatorPtr TableCreator_;
        TDataPusherPtr DataPusher_;
        TLbReaderPoolPtr Lb_;
        std::shared_ptr<NLb::TResourceDispatcher> UncommittedMemoryDispatcher_;
        std::shared_ptr<NTvmAuth::TTvmClient> Tvm_;

        NUnistat::TSignalDiff<> UnistatRowsIn_ = {"lb.rows.in"};
        NUnistat::TSignalDiff<> UnistatRowsOut_ = {"lb.rows.out"};
        NUnistat::TSignalDiff<> UnistatErrors_ = {"lb.parsing_errors"};
    };
}
