#include "yt_query.h"

#include <passport/infra/libs/cpp/yt/batch.h>
#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/name_table.h>
#include <yt/yt/client/table_client/row_buffer.h>

namespace NPassport::NLbcbck {
    NYt::TWriteQuery TRowsConverter::Convert(const TString& table, size_t offset, size_t count) const {
        return ConvertImpl(table, GetSpan(offset, count));
    }

    static NYT::NTableClient::TNameTablePtr CreateNameTable() {
        NYT::NTableClient::TNameTablePtr res = NYT::New<NYT::NTableClient::TNameTable>();
        res->RegisterName("user_ip");
        res->RegisterName("host_client");
        res->RegisterName("unixtime");
        res->RegisterName("def_uid");
        res->RegisterName("uids");
        res->RegisterName("user_port");
        res->RegisterName("dummy");
        return res;
    }
    static const NYT::NTableClient::TNameTablePtr NAME_TABLE = CreateNameTable();

    NYt::TWriteQuery TRowsConverter::ConvertImpl(const TString& path,
                                                 std::span<const TWritableRow> data) {
        NYt::TWriteQuery res;
        res.Impl = std::make_unique<NYt::TWriteQueryImpl>();
        NYt::TWriteSubQuery& sub = res.Impl->Subqueries.emplace_back();

        sub.Path = path;
        sub.NameTable = NAME_TABLE;

        sub.RowBuffer = NYT::New<NYT::NTableClient::TRowBuffer>();
        std::vector<NYT::NTableClient::TUnversionedRow> vecRows;
        vecRows.reserve(data.size());

        for (const TWritableRow& w : data) {
            int colIdx = 0;
            NYT::NTableClient::TUnversionedRowBuilder builder;

            auto addValue = [&builder, &colIdx, &sub](const auto& val) {
                NYT::NTableClient::TUnversionedValue unversionedValue{};
                NYT::NTableClient::ToUnversionedValue(&unversionedValue, val, sub.RowBuffer, colIdx++);
                builder.AddValue(unversionedValue);
            };
            auto addNullValue = [&builder, &colIdx]() {
                builder.AddValue(
                    MakeUnversionedSentinelValue(NYT::NTableClient::EValueType::Null, colIdx++));
            };

            addValue(w.UserIp);
            addValue(w.HostClient);
            addValue(w.Unixtime);
            addValue(w.DefUid);
            addValue(w.Uids);
            if (w.UserPort) {
                addValue(w.UserPort);
            } else {
                addNullValue();
            }
            addValue(NYT::NYTree::IMapNodePtr());

            vecRows.push_back(sub.RowBuffer->CaptureRow(builder.GetRow()));
        }

        res.Size = sub.RowBuffer->GetSize();
        sub.Range = MakeSharedRange(std::move(vecRows), sub.RowBuffer);

        return res;
    }
}
