#pragma once

#include <passport/infra/libs/cpp/yt/query.h>
#include <passport/infra/libs/cpp/yt/yt_client.h>

#include <unordered_set>

#include <span>

namespace NPassport::NLbcbck {
    struct TWritableRow {
        TString UserIp;
        TString HostClient;
        ui32 Unixtime = 0;
        ui64 DefUid = 0;
        TString Uids;
        ui16 UserPort = 0;

        bool operator==(const TWritableRow& r) const {
            return UserIp == r.UserIp &&
                   HostClient == r.HostClient &&
                   Unixtime == r.Unixtime &&
                   DefUid == r.DefUid &&
                   Uids == r.Uids &&
                   UserPort == r.UserPort;
        }
    };

    class TRowsConverter: public NYt::TBaseConverter<TWritableRow> {
    public:
        NYt::TWriteQuery Convert(
            const TString& table,
            size_t offset,
            size_t count) const override;

        static NYt::TWriteQuery ConvertImpl(
            const TString& path,
            std::span<const TWritableRow> data);
    };
}

namespace std {
    template <>
    struct hash<NPassport::NLbcbck::TWritableRow> {
        std::size_t operator()(const NPassport::NLbcbck::TWritableRow& r) const {
            return hash<TString>()(r.UserIp) + hash<TString>()(r.HostClient) + hash<ui32>()(r.Unixtime);
        }
    };
}

template <>
inline void Out<NPassport::NLbcbck::TWritableRow>(IOutputStream& o, const NPassport::NLbcbck::TWritableRow& value) {
    o << "userip=" << value.UserIp
      << ". host_client=" << value.HostClient
      << ". unixtime=" << value.Unixtime
      << ". def_uid=" << value.DefUid
      << ". uids=" << value.Uids
      << ". port=" << value.UserPort
      << Endl;
}
