#include "yt_schema.h"

#include <passport/infra/libs/cpp/yt/yt_impl.h>

#include <yt/yt/client/table_client/comparator.h>
#include <yt/yt/client/table_client/helpers.h>
#include <yt/yt/client/table_client/logical_type.h>
#include <yt/yt/client/table_client/name_table.h>
#include <yt/yt/client/table_client/row_buffer.h>

namespace NPassport::NLbcbck {
    NYt::TTableSchema CreateYtSchema() {
        auto column = [](const TString& name, NYT::NTableClient::ESimpleLogicalValueType type) {
            return NYT::NTableClient::TColumnSchema(
                name,
                SimpleLogicalType(type),
                NYT::NTableClient::ESortOrder::Ascending);
        };

        NYt::TTableSchema res;
        res.Impl = std::make_shared<NYt::TTableSchemaImpl>();

        res.Impl->Schema = NYT::NTableClient::TTableSchema(
            std::vector<NYT::NTableClient::TColumnSchema>({
                column("user_ip", NYT::NTableClient::ESimpleLogicalValueType::String),
                column("host_client", NYT::NTableClient::ESimpleLogicalValueType::String),
                column("unixtime", NYT::NTableClient::ESimpleLogicalValueType::Uint32),
                column("def_uid", NYT::NTableClient::ESimpleLogicalValueType::Uint64),
                column("uids", NYT::NTableClient::ESimpleLogicalValueType::String),
                NYT::NTableClient::TColumnSchema(
                    "user_port",
                    OptionalLogicalType(SimpleLogicalType(
                        NYT::NTableClient::ESimpleLogicalValueType::Uint16)),
                    NYT::NTableClient::ESortOrder::Ascending),
                NYT::NTableClient::TColumnSchema(
                    "dummy",
                    NYT::NTableClient::ESimpleLogicalValueType::Any),
            }),
            true,
            true);

        return res;
    }
}
