import datetime
import sys

import yt.wrapper as yt


def get_token(prefix):
    with open('./%s_token' % prefix) as f:
        return f.read()


yt = yt.YtClient(proxy='hahn', token=get_token('yt'))


def is_recompressed():
    if datetime.datetime.now().hour < 6:
        return True

    date = datetime.date.today() - datetime.timedelta(days=7)
    table = '//home/passport-rt/production/lbcbck/' + date.strftime('%Y-%m-%d')
    return (
        bool(yt.exists(table))
        and yt.get_attribute(table, 'tablet_state') == 'mounted'
        and yt.get_attribute(table, 'compression_codec') == 'brotli_8'
    )


def does_new_table_exist():
    if datetime.datetime.now().hour < 1:
        return True

    date = datetime.date.today() + datetime.timedelta(days=1)
    table = '//home/passport-rt/production/lbcbck/' + date.strftime('%Y-%m-%d')

    return bool(yt.exists(table)) and yt.get_attribute(table, 'tablet_state') == 'mounted'


if __name__ == '__main__':
    print(is_recompressed())
    print(does_new_table_exist())
