import argparse
import datetime

from sandbox.projects.passport.lbcbck_recompression.lib.recompression import run

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='recompress lbcbck table')
    parser.add_argument('date', type=str, help='date for table needed to be recompressed')
    parser.add_argument('oauth_token', type=str, help='oauth token with scopes for YT')
    parser.add_argument('--retries', type=int, default=3, help='retries')
    args = parser.parse_args()

    date = datetime.datetime.strptime(args.date, '%Y-%m-%d').date()
    assert args.retries >= 1

    run(date=date, oauth_token=args.oauth_token, retries=args.retries)
