#include <passport/infra/daemons/lbcbck/src/yt_query.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NLbcbck;

Y_UNIT_TEST_SUITE(Lbcbck) {
    Y_UNIT_TEST(eq) {
        TWritableRow val({"0.0.0.1", "ya.ru", 100500, 0, "kek"});
        UNIT_ASSERT_VALUES_EQUAL(val, val);

        UNIT_ASSERT_VALUES_UNEQUAL(val, TWritableRow({"0.0.0.2", "ya.ru", 100500, 0, "kek"}));
    }

    Y_UNIT_TEST(hash) {
        std::unordered_set<TWritableRow> set;
        UNIT_ASSERT(set.insert({"0.0.0.1", "ya.ru", 100500, 0, "kek"}).second);
        UNIT_ASSERT(!set.insert({"0.0.0.1", "ya.ru", 100500, 0, "kek"}).second);

        for (int i = 0; i < 10; ++i) {
            TWritableRow r = {"0.0.0.1", "ya.ru", 100500, 0, "kek"};
            r.Unixtime = i;
            UNIT_ASSERT(set.insert(r).second);
            UNIT_ASSERT(!set.insert(r).second);
        }

        UNIT_ASSERT_VALUES_EQUAL(11, set.size());
    }
}
