import json
import time


def deep_sorted(item):
    def key_func(x):
        if isinstance(x, dict):
            return sorted((key, key_func(value)) for key, value in x.items())
        return x

    if isinstance(item, dict):
        return {key: deep_sorted(value) for key, value in item.items()}
    if isinstance(item, list):
        return sorted((deep_sorted(x) for x in item), key=key_func)
    if isinstance(item, tuple):
        return tuple(deep_sorted(x) for x in item)
    return item


def pretty_json(value, indent=2, **kwargs):
    return json.dumps(json.loads(value), indent=indent, **kwargs)


def test_with_deadline(func, deadline):
    while True:
        try:
            return func()
        except AssertionError:
            if time.time() > deadline:
                raise
            time.sleep(1)


def test_with_timeout(func, timeout):
    return test_with_deadline(func, time.time() + timeout)
