import json
import sys

SAS = "sas"
IVA = "iva"
MAN = "man"


def gen_hosts(prefix, number):
    return json.dumps(['%s%d.passport.yandex.net:3301' % (prefix, i + 1) for i in range(number)])


SETTINGS = {
    "testing": {
        "REPLICATION_HOSTS": "[]",
        "ALLOWED_TVM_ID": "[ 2020010 ]",
    },
    "production": {
        "REPLICATION_HOSTS": {
            SAS: gen_hosts("kvs-api-s", 4),
            IVA: gen_hosts("kvs-api-i", 4),
            MAN: gen_hosts("kvs-api-f", 4),
        },
        "ALLOWED_TVM_ID": "[ 2020012 ]",
    },
}


def do(template, env, dc):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        if isinstance(value, dict):
            value = value[dc]
        template = template.replace('<<%s>>' % key, str(value))

    template = template.replace('<<__DC__>>', str(dc))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


def get_dc(hostname):
    if hostname.startswith('kvs-api-s'):
        return SAS
    if hostname.startswith('kvs-api-f'):
        return MAN
    if hostname.startswith('kvs-api-i'):
        return IVA

    if 'dev' in hostname or 'test' in hostname:
        return None

    raise Exception('Unconfigured DC for host: %s' % hostname)


if __name__ == '__main__':
    if len(sys.argv) != 4:
        print("Usage: %s <template_file> <env> <hostname>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2], get_dc(sys.argv[3]))
