#pragma once

#include <passport/infra/libs/cpp/dbpool/handle.h>

namespace NPassport::NLbchdb {
    class IBlackboxClient {
    public:
        struct TRequest {
            TString Path;
            TString Body;

            bool operator==(const TRequest& o) const {
                return Body == o.Body && Path == o.Path;
            }
        };

        struct TRequestHandle {
            TRequest Req;
            NDbPool::TNonBlockingHandle Handle;

            bool operator==(const TRequestHandle& o) const {
                return Req == o.Req;
            }
        };

        virtual ~IBlackboxClient() = default;

        virtual TRequestHandle SendRequest(const TRequest& req) = 0;
        virtual TString WaitResponse(TRequestHandle& req) const = 0;
    };

    class TBlackboxClient: public IBlackboxClient {
    public:
        class TParseException: public yexception {
        };

    public:
        TBlackboxClient(NDbPool::TDbPool& bb);

        TRequestHandle SendRequest(const TRequest& req) override;
        TString WaitResponse(TRequestHandle& req) const override;

        static TRequest CreateUserinfoRequest(const TStringBuf email,
                                              const TString& path = "/blackbox");
        static TRequest CreateEmailBindingsRequest(TStringBuf email,
                                                   const TString& path = "/blackbox");

        static std::optional<ui64> ParseResponseForUserinfo(const TStringBuf response);
        static std::vector<ui64> ParseResponseForEmailBindings(const TStringBuf response);

    private:
        NDbPool::TDbPool& Bb_;
    };
}
