#include "encryptor.h"

namespace NPassport::NLbchdb::NCrypto {
    TEncryptor::TEncryptor(TKeyRingMap&& keyRingMap)
        : KeyRingMap_(std::move(keyRingMap))
    {
    }

    TEncryptor::TEncryptResult TEncryptor::Encrypt(const TStringBuf input, EKeyRing ring) const {
        const TKeyRingHolderWithDefaultKey& holder = GetKeyRing(ring);
        TEncryptResult res{
            .KeyId = holder.DefaultKeyID(),
        };

        TString err;
        Y_ENSURE(NUtils::TCrypto::EncryptGcm(
                     holder.DefaultKey(),
                     input,
                     res.Crypt,
                     &err),
                 "Encryptor: failed to decrypt with aes gcm: " << err);

        return res;
    }

    const TKeyRingHolderWithDefaultKey& TEncryptor::GetKeyRing(EKeyRing ring) const {
        auto it = KeyRingMap_.find(ring);
        Y_ENSURE(it != KeyRingMap_.cend(), "Encryptor: no keys for ring '" << ring << "'");
        return it->second;
    }
}
